/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSSEC;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.EDNSOption;

public class DnssecAlgorithmOption
extends EDNSOption {
    private List<Integer> algCodes;

    private DnssecAlgorithmOption(int code) {
        super(code);
        switch (code) {
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid option code, must be one of DAU, DHU, N3U");
            }
        }
        this.algCodes = new ArrayList<Integer>();
    }

    public DnssecAlgorithmOption(int code, List<Integer> algCodes) {
        this(code);
        this.algCodes.addAll(algCodes);
    }

    public DnssecAlgorithmOption(int code, int ... algCodes) {
        this(code);
        if (algCodes != null) {
            for (int algCode : algCodes) {
                this.algCodes.add(algCode);
            }
        }
    }

    public List<Integer> getAlgorithms() {
        return Collections.unmodifiableList(this.algCodes);
    }

    @Override
    void optionFromWire(DNSInput in) throws IOException {
        this.algCodes.clear();
        while (in.remaining() > 0) {
            this.algCodes.add(in.readU8());
        }
    }

    @Override
    void optionToWire(DNSOutput out) {
        this.algCodes.forEach(out::writeU8);
    }

    @Override
    String optionToString() {
        return EDNSOption.Code.string(this.getCode()) + ": [" + this.algCodes.stream().map(DNSSEC.Algorithm::string).collect(Collectors.joining(", ")) + "]";
    }
}

