/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.util.HashMap;

class Mnemonic {
    static final int CASE_SENSITIVE = 1;
    static final int CASE_UPPER = 2;
    static final int CASE_LOWER = 3;
    private HashMap<String, Integer> strings;
    private HashMap<Integer, String> values;
    private String description;
    private int wordcase;
    private String prefix;
    private int max;
    private boolean numericok;

    public Mnemonic(String description, int wordcase) {
        this.description = description;
        this.wordcase = wordcase;
        this.strings = new HashMap();
        this.values = new HashMap();
        this.max = Integer.MAX_VALUE;
    }

    public void setMaximum(int max) {
        this.max = max;
    }

    public void setPrefix(String prefix) {
        this.prefix = this.sanitize(prefix);
    }

    public void setNumericAllowed(boolean numeric) {
        this.numericok = numeric;
    }

    public void check(int val) {
        if (val < 0 || val > this.max) {
            throw new IllegalArgumentException(this.description + " " + val + "is out of range");
        }
    }

    private String sanitize(String str) {
        if (this.wordcase == 2) {
            return str.toUpperCase();
        }
        if (this.wordcase == 3) {
            return str.toLowerCase();
        }
        return str;
    }

    private int parseNumeric(String s2) {
        try {
            int val = Integer.parseInt(s2);
            if (val >= 0 && val <= this.max) {
                return val;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public void add(int val, String str) {
        this.check(val);
        str = this.sanitize(str);
        this.strings.put(str, val);
        this.values.put(val, str);
    }

    public void remove(int val) {
        this.values.remove(val);
        this.strings.entrySet().removeIf(entry -> (Integer)entry.getValue() == val);
    }

    public void addAlias(int val, String str) {
        this.check(val);
        str = this.sanitize(str);
        this.strings.put(str, val);
    }

    public void removeAlias(String str) {
        str = this.sanitize(str);
        this.strings.remove(str);
    }

    public void addAll(Mnemonic source) {
        if (this.wordcase != source.wordcase) {
            throw new IllegalArgumentException(source.description + ": wordcases do not match");
        }
        this.strings.putAll(source.strings);
        this.values.putAll(source.values);
    }

    public String getText(int val) {
        this.check(val);
        String str = this.values.get(val);
        if (str != null) {
            return str;
        }
        str = Integer.toString(val);
        if (this.prefix != null) {
            return this.prefix + str;
        }
        return str;
    }

    public int getValue(String str) {
        int val;
        Integer value = this.strings.get(str = this.sanitize(str));
        if (value != null) {
            return value;
        }
        if (this.prefix != null && str.startsWith(this.prefix) && (val = this.parseNumeric(str.substring(this.prefix.length()))) >= 0) {
            return val;
        }
        if (this.numericok) {
            return this.parseNumeric(str);
        }
        return -1;
    }
}

