/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Compression;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Tokenizer;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.utils.base16;

public class NSAPRecord
extends Record {
    private byte[] address;

    NSAPRecord() {
    }

    private static byte[] checkAndConvertAddress(String address) {
        if (!address.substring(0, 2).equalsIgnoreCase("0x")) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        boolean partial = false;
        int current = 0;
        for (int i = 2; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (c == '.') continue;
            int value = Character.digit(c, 16);
            if (value == -1) {
                return null;
            }
            if (partial) {
                bytes.write(current += value);
                partial = false;
                continue;
            }
            current = value << 4;
            partial = true;
        }
        if (partial) {
            return null;
        }
        return bytes.toByteArray();
    }

    public NSAPRecord(Name name, int dclass, long ttl, String address) {
        super(name, 22, dclass, ttl);
        this.address = NSAPRecord.checkAndConvertAddress(address);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid NSAP address " + address);
        }
    }

    @Override
    protected void rrFromWire(DNSInput in) {
        this.address = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String addr = st.getString();
        this.address = NSAPRecord.checkAndConvertAddress(addr);
        if (this.address == null) {
            throw st.exception("invalid NSAP address " + addr);
        }
    }

    public String getAddress() {
        return NSAPRecord.byteArrayToString(this.address, false);
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }

    @Override
    protected String rrToString() {
        return "0x" + base16.toString(this.address);
    }
}

