/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.IOException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Compression;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Tokenizer;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Type;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.TypeBitmap;

public class NSECRecord
extends Record {
    private Name next;
    private TypeBitmap types;

    NSECRecord() {
    }

    public NSECRecord(Name name, int dclass, long ttl, Name next, int[] types) {
        super(name, 47, dclass, ttl);
        this.next = NSECRecord.checkName("next", next);
        for (int value : types) {
            Type.check(value);
        }
        this.types = new TypeBitmap(types);
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.next = new Name(in);
        this.types = new TypeBitmap(in);
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.next.toWire(out, null, false);
        this.types.toWire(out);
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.next = st.getName(origin);
        this.types = new TypeBitmap(st);
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.next);
        if (!this.types.empty()) {
            sb.append(' ');
            sb.append(this.types.toString());
        }
        return sb.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public int[] getTypes() {
        return this.types.toArray();
    }

    public boolean hasType(int type) {
        return this.types.contains(type);
    }
}

