/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.io.IOException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Compression;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSInput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSOutput;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Options;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Tokenizer;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.utils.base64;

public class OPENPGPKEYRecord
extends Record {
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    public OPENPGPKEYRecord(Name name, int dclass, long ttl, byte[] cert) {
        super(name, 61, dclass, ttl);
        this.cert = cert;
    }

    @Override
    protected void rrFromWire(DNSInput in) {
        this.cert = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.cert = st.getBase64();
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append("(\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                sb.append(base64.toString(this.cert));
            }
        }
        return sb.toString();
    }

    public byte[] getCert() {
        return this.cert;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.cert);
    }
}

