/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.AndroidResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.FallbackPropertyResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.InitializationException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.JndiContextResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.PropertyResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.ResolvConfResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.ResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.SunJvmResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.WindowsResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

public final class ResolverConfig {
    private static final Logger log = LoggerFactory.getLogger(ResolverConfig.class);
    public static final String CONFIGPROVIDER_SKIP_INIT = "dnsjava.configprovider.skipinit";
    private final List<InetSocketAddress> servers = new ArrayList<InetSocketAddress>(2);
    private final List<Name> searchlist = new ArrayList<Name>(0);
    private int ndots = 1;
    private static ResolverConfig currentConfig;
    private static List<ResolverConfigProvider> configProviders;

    private static void checkInitialized() {
        if (configProviders == null) {
            configProviders = new ArrayList<ResolverConfigProvider>(8);
            if (!Boolean.getBoolean(CONFIGPROVIDER_SKIP_INIT)) {
                configProviders.add(new PropertyResolverConfigProvider());
                configProviders.add(new ResolvConfResolverConfigProvider());
                configProviders.add(new WindowsResolverConfigProvider());
                configProviders.add(new AndroidResolverConfigProvider());
                configProviders.add(new JndiContextResolverConfigProvider());
                configProviders.add(new SunJvmResolverConfigProvider());
                configProviders.add(new FallbackPropertyResolverConfigProvider());
            }
        }
        if (currentConfig == null) {
            ResolverConfig.refresh();
        }
    }

    public static synchronized ResolverConfig getCurrentConfig() {
        ResolverConfig.checkInitialized();
        return currentConfig;
    }

    public static synchronized List<ResolverConfigProvider> getConfigProviders() {
        ResolverConfig.checkInitialized();
        return Collections.unmodifiableList(configProviders);
    }

    public static synchronized void setConfigProviders(List<ResolverConfigProvider> providers) {
        configProviders = new ArrayList<ResolverConfigProvider>(providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig newConfig = new ResolverConfig();
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            currentConfig = newConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ResolverConfig() {
        for (ResolverConfigProvider provider : configProviders) {
            if (!provider.isEnabled()) continue;
            try {
                List<Name> lsearchPaths;
                provider.initialize();
                if (this.servers.isEmpty()) {
                    this.servers.addAll(provider.servers());
                }
                if (this.searchlist.isEmpty() && !(lsearchPaths = provider.searchPaths()).isEmpty()) {
                    this.searchlist.addAll(lsearchPaths);
                    this.ndots = provider.ndots();
                }
                if (this.servers.isEmpty() || this.searchlist.isEmpty()) continue;
                return;
            }
            catch (InitializationException e) {
                log.warn("Failed to initialize provider", e);
            }
        }
        if (this.servers.isEmpty()) {
            this.servers.add(new InetSocketAddress(InetAddress.getLoopbackAddress(), 53));
        }
    }

    public List<InetSocketAddress> servers() {
        return this.servers;
    }

    public InetSocketAddress server() {
        return this.servers.get(0);
    }

    public List<Name> searchPath() {
        return this.searchlist;
    }

    public int ndots() {
        return this.ndots;
    }
}

