/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava;

import java.security.PrivateKey;
import java.time.Duration;
import java.time.Instant;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DNSSEC;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.KEYRecord;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Message;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Options;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.SIGRecord;

public class SIG0 {
    private static final Duration VALIDITY = Duration.ofSeconds(300L);

    private SIG0() {
    }

    public static void signMessage(Message message, KEYRecord key, PrivateKey privkey, SIGRecord previous) throws DNSSEC.DNSSECException {
        SIG0.signMessage(message, key, privkey, previous, Instant.now());
    }

    public static void signMessage(Message message, KEYRecord key, PrivateKey privkey, SIGRecord previous, Instant timeSigned) throws DNSSEC.DNSSECException {
        int validityOption = Options.intValue("sig0validity");
        Duration validity = validityOption < 0 ? VALIDITY : Duration.ofSeconds(validityOption);
        Instant timeExpires = timeSigned.plus(validity);
        SIGRecord sig = DNSSEC.signMessage(message, previous, key, privkey, timeSigned, timeExpires);
        message.addRecord(sig, 3);
    }

    public static void verifyMessage(Message message, byte[] b, KEYRecord key, SIGRecord previous) throws DNSSEC.DNSSECException {
        SIG0.verifyMessage(message, b, key, previous, Instant.now());
    }

    public static void verifyMessage(Message message, byte[] b, KEYRecord key, SIGRecord previous, Instant now) throws DNSSEC.DNSSECException {
        SIGRecord sig = null;
        for (Record record : message.getSection(3)) {
            if (record.getType() != 24 || ((SIGRecord)record).getTypeCovered() != 0) continue;
            sig = (SIGRecord)record;
            break;
        }
        DNSSEC.verifyMessage(message, b, sig, previous, key, now);
    }
}

