/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.BaseResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.config.ResolverConfigProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

public class JndiContextResolverConfigProvider
implements ResolverConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(JndiContextResolverConfigProvider.class);
    private InnerJndiContextResolverConfigProvider inner;

    public JndiContextResolverConfigProvider() {
        if (!System.getProperty("java.vendor").contains("Android")) {
            try {
                this.inner = new InnerJndiContextResolverConfigProvider();
            }
            catch (NoClassDefFoundError e) {
                log.debug("JNDI DNS not available");
            }
        }
    }

    @Override
    public void initialize() {
        this.inner.initialize();
    }

    @Override
    public List<InetSocketAddress> servers() {
        return this.inner.servers();
    }

    @Override
    public List<Name> searchPaths() {
        return this.inner.searchPaths();
    }

    @Override
    public boolean isEnabled() {
        return this.inner != null;
    }

    private static final class InnerJndiContextResolverConfigProvider
    extends BaseResolverConfigProvider {
        private static final Logger log = LoggerFactory.getLogger(InnerJndiContextResolverConfigProvider.class);

        private InnerJndiContextResolverConfigProvider() {
        }

        @Override
        public void initialize() {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns://");
            String servers = null;
            try {
                InitialDirContext ctx = new InitialDirContext(env);
                servers = (String)ctx.getEnvironment().get("java.naming.provider.url");
                ctx.close();
            }
            catch (NamingException ctx) {
                // empty catch block
            }
            if (servers != null) {
                StringTokenizer st = new StringTokenizer(servers, " ");
                while (st.hasMoreTokens()) {
                    String server = st.nextToken();
                    try {
                        URI serverUri = new URI(server);
                        String host = serverUri.getHost();
                        if (host == null || host.isEmpty()) continue;
                        int port = serverUri.getPort();
                        if (port == -1) {
                            port = 53;
                        }
                        this.addNameserver(new InetSocketAddress(host, port));
                    }
                    catch (URISyntaxException e) {
                        log.debug("Could not parse {} as a dns server, ignoring", (Object)server, (Object)e);
                    }
                }
            }
        }

        static {
            log.debug("JNDI class: {}", (Object)DirContext.class.getName());
        }
    }
}

