/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.tools;

import java.io.IOException;
import java.net.InetAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.DClass;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.EDNSOption;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Message;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Name;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Record;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.ReverseMap;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.SimpleResolver;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.TSIG;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.Type;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.WireParseException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.ZoneTransferException;
import ru.yandex.clickhouse.jdbcbridge.internal.dnsjava.ZoneTransferIn;

public class dig {
    static Name name = null;
    static int type = 1;
    static int dclass = 1;

    static void usage() {
        System.out.println("; dnsjava dig");
        System.out.println("Usage: dig [@server] name [<type>] [<class>] [options]");
        System.exit(0);
    }

    static void doQuery(Message response, long ms) {
        System.out.println("; dnsjava dig");
        System.out.println(response);
        System.out.println(";; Query time: " + ms + " ms");
    }

    public static void main(String[] argv) throws IOException {
        boolean printQuery;
        SimpleResolver res;
        block35: {
            String server = null;
            res = null;
            printQuery = false;
            if (argv.length < 1) {
                dig.usage();
            }
            try {
                String nameString;
                int arg = 0;
                if (argv[arg].startsWith("@")) {
                    server = argv[arg++].substring(1);
                }
                res = server != null ? new SimpleResolver(server) : new SimpleResolver();
                if ((nameString = argv[arg++]).equals("-x")) {
                    name = ReverseMap.fromAddress(argv[arg++]);
                    type = 12;
                    dclass = 1;
                } else {
                    name = Name.fromString(nameString, Name.root);
                    type = Type.value(argv[arg]);
                    if (type < 0) {
                        type = 1;
                    } else {
                        ++arg;
                    }
                    dclass = DClass.value(argv[arg]);
                    if (dclass < 0) {
                        dclass = 1;
                    } else {
                        ++arg;
                    }
                }
                while (argv[arg].startsWith("-") && argv[arg].length() > 1) {
                    block3 : switch (argv[arg].charAt(1)) {
                        case 'p': {
                            String portStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int port = Integer.parseInt(portStr);
                            if (port < 0 || port > 65535) {
                                System.out.println("Invalid port");
                                return;
                            }
                            res.setPort(port);
                            break;
                        }
                        case 'b': {
                            InetAddress addr;
                            String addrStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            try {
                                addr = InetAddress.getByName(addrStr);
                            }
                            catch (Exception e) {
                                System.out.println("Invalid address");
                                return;
                            }
                            res.setLocalAddress(addr);
                            break;
                        }
                        case 'k': {
                            String key = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            String[] parts = key.split("[:/]", 3);
                            switch (parts.length) {
                                case 2: {
                                    res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, parts[0], parts[1]));
                                    break block3;
                                }
                                case 3: {
                                    res.setTSIGKey(new TSIG(parts[0], parts[1], parts[2]));
                                    break block3;
                                }
                            }
                            throw new IllegalArgumentException("Invalid TSIG key specification");
                        }
                        case 't': {
                            res.setTCP(true);
                            break;
                        }
                        case 'i': {
                            res.setIgnoreTruncation(true);
                            break;
                        }
                        case 'e': {
                            String ednsStr = argv[arg].length() > 2 ? argv[arg].substring(2) : argv[++arg];
                            int edns = Integer.parseInt(ednsStr);
                            if (edns < 0 || edns > 1) {
                                System.out.println("Unsupported EDNS level: " + edns);
                                return;
                            }
                            res.setEDNS(edns);
                            break;
                        }
                        case 'd': {
                            res.setEDNS(0, 0, 32768, new EDNSOption[0]);
                            break;
                        }
                        case 'q': {
                            printQuery = true;
                            break;
                        }
                        default: {
                            System.out.print("Invalid option: ");
                            System.out.println(argv[arg]);
                        }
                    }
                    ++arg;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (name != null) break block35;
                dig.usage();
            }
        }
        if (res == null) {
            res = new SimpleResolver();
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message query = Message.newQuery(rec);
        if (printQuery) {
            System.out.println(query);
        }
        if (type == 252) {
            System.out.println("; dnsjava dig <> " + name + " axfr");
            ZoneTransferIn xfrin2 = ZoneTransferIn.newAXFR(name, res.getAddress(), res.getTSIGKey());
            xfrin2.setTimeout(res.getTimeout());
            try {
                xfrin2.run(new ZoneTransferIn.ZoneTransferHandler(){

                    @Override
                    public void startAXFR() {
                    }

                    @Override
                    public void startIXFR() {
                    }

                    @Override
                    public void startIXFRDeletes(Record soa) {
                    }

                    @Override
                    public void startIXFRAdds(Record soa) {
                    }

                    @Override
                    public void handleRecord(Record r) {
                        System.out.println(r);
                    }
                });
            }
            catch (ZoneTransferException e) {
                throw new WireParseException(e.getMessage());
            }
        } else {
            long startTime = System.currentTimeMillis();
            Message response = res.send(query);
            long endTime = System.currentTimeMillis();
            dig.doQuery(response, endTime - startTime);
        }
    }
}

