/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonGenerator;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonToken;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.type.WritableTypeId;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JavaType;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JsonNode;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.SerializationFeature;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.SerializerProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.jsontype.TypeSerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ser.std.StdSerializer;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value) throws JsonMappingException {
        prov.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value.getClass().getName()));
    }
}

