/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ser.std;

import java.io.IOException;
import java.net.InetAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.annotation.JsonFormat;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonGenerator;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.JsonToken;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.core.type.WritableTypeId;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.BeanProperty;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.JsonSerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.SerializerProvider;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.jsontype.TypeSerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ser.ContextualSerializer;
import ru.yandex.clickhouse.jdbcbridge.internal.jackson.databind.ser.std.StdScalarSerializer;

public class InetAddressSerializer
extends StdScalarSerializer<InetAddress>
implements ContextualSerializer {
    protected final boolean _asNumeric;

    public InetAddressSerializer() {
        this(false);
    }

    public InetAddressSerializer(boolean asNumeric) {
        super(InetAddress.class);
        this._asNumeric = asNumeric;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Shape shape;
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        boolean asNumeric = false;
        if (format != null && ((shape = format.getShape()).isNumeric() || shape == JsonFormat.Shape.ARRAY)) {
            asNumeric = true;
        }
        if (asNumeric != this._asNumeric) {
            return new InetAddressSerializer(asNumeric);
        }
        return this;
    }

    @Override
    public void serialize(InetAddress value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        String str;
        if (this._asNumeric) {
            str = value.getHostAddress();
        } else {
            str = value.toString().trim();
            int ix = str.indexOf(47);
            if (ix >= 0) {
                str = ix == 0 ? str.substring(1) : str.substring(0, ix);
            }
        }
        g2.writeString(str);
    }

    @Override
    public void serializeWithType(InetAddress value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId((Object)value, InetAddress.class, JsonToken.VALUE_STRING));
        this.serialize(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }
}

