/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument;

import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tags;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.util.TimeUtils;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public interface TimeGauge
extends Gauge {
    public static <T> Builder<T> builder(String name, @Nullable T obj, TimeUnit fUnits, ToDoubleFunction<T> f) {
        return new Builder(name, obj, fUnits, f);
    }

    public TimeUnit baseTimeUnit();

    default public double value(TimeUnit unit) {
        return TimeUtils.convert(this.value(), this.baseTimeUnit(), unit);
    }

    public static class Builder<T> {
        private final String name;
        private final TimeUnit fUnits;
        private final ToDoubleFunction<T> f;
        private Tags tags = Tags.empty();
        @Nullable
        private final T obj;
        @Nullable
        private String description;

        private Builder(String name, @Nullable T obj, TimeUnit fUnits, ToDoubleFunction<T> f) {
            this.name = name;
            this.obj = obj;
            this.fUnits = fUnits;
            this.f = f;
        }

        public Builder<T> tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder<T> tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder<T> tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public Builder<T> description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public TimeGauge register(MeterRegistry registry) {
            return registry.more().timeGauge(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.GAUGE), this.obj, this.fUnits, this.f);
        }
    }
}

