/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.db;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import javax.sql.DataSource;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tags;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.MeterBinder;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullApi;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullFields;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

@NonNullApi
@NonNullFields
public class PostgreSQLDatabaseMetrics
implements MeterBinder {
    private static final String SELECT = "SELECT ";
    private static final String QUERY_DEAD_TUPLE_COUNT = PostgreSQLDatabaseMetrics.getUserTableQuery("n_dead_tup");
    private static final String QUERY_TIMED_CHECKPOINTS_COUNT = PostgreSQLDatabaseMetrics.getBgWriterQuery("checkpoints_timed");
    private static final String QUERY_REQUESTED_CHECKPOINTS_COUNT = PostgreSQLDatabaseMetrics.getBgWriterQuery("checkpoints_req");
    private static final String QUERY_BUFFERS_CLEAN = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_clean");
    private static final String QUERY_BUFFERS_BACKEND = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_backend");
    private static final String QUERY_BUFFERS_CHECKPOINT = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_checkpoint");
    private final Logger logger = LoggerFactory.getLogger(PostgreSQLDatabaseMetrics.class);
    private final String database;
    private final DataSource postgresDataSource;
    private final Iterable<Tag> tags;
    private final Map<String, Double> beforeResetValuesCacheMap;
    private final Map<String, Double> previousValueCacheMap;
    private final String queryConnectionCount;
    private final String queryReadCount;
    private final String queryInsertCount;
    private final String queryTempBytes;
    private final String queryUpdateCount;
    private final String queryDeleteCount;
    private final String queryBlockHits;
    private final String queryBlockReads;
    private final String queryTransactionCount;

    public PostgreSQLDatabaseMetrics(DataSource postgresDataSource, String database) {
        this(postgresDataSource, database, Tags.empty());
    }

    public PostgreSQLDatabaseMetrics(DataSource postgresDataSource, String database, Iterable<Tag> tags) {
        this.postgresDataSource = postgresDataSource;
        this.database = database;
        this.tags = Tags.of(tags).and(PostgreSQLDatabaseMetrics.createDbTag(database));
        this.beforeResetValuesCacheMap = new ConcurrentHashMap<String, Double>();
        this.previousValueCacheMap = new ConcurrentHashMap<String, Double>();
        this.queryConnectionCount = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "SUM(numbackends)");
        this.queryReadCount = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "tup_fetched");
        this.queryInsertCount = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "tup_inserted");
        this.queryTempBytes = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "tmp_bytes");
        this.queryUpdateCount = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "tup_updated");
        this.queryDeleteCount = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "tup_deleted");
        this.queryBlockHits = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "blks_hit");
        this.queryBlockReads = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "blks_read");
        this.queryTransactionCount = PostgreSQLDatabaseMetrics.getDBStatQuery(database, "xact_commit + xact_rollback");
    }

    private static Tag createDbTag(String database) {
        return Tag.of("database", database);
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder("postgres.size", this.postgresDataSource, dataSource -> this.getDatabaseSize().longValue()).tags(this.tags).description("The database size").register(registry);
        Gauge.builder("postgres.connections", this.postgresDataSource, dataSource -> this.getConnectionCount().longValue()).tags(this.tags).description("Number of active connections to the given db").register(registry);
        FunctionCounter.builder("postgres.blocks.hits", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.blocks.hits", this::getBlockHits)).tags(this.tags).description("Number of times disk blocks were found already in the buffer cache, so that a read was not necessary").register(registry);
        FunctionCounter.builder("postgres.blocks.reads", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.blocks.reads", this::getBlockReads)).tags(this.tags).description("Number of disk blocks read in this database").register(registry);
        FunctionCounter.builder("postgres.transactions", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.transactions", this::getTransactionCount)).tags(this.tags).description("Total number of transactions executed (commits + rollbacks)").register(registry);
        Gauge.builder("postgres.locks", this.postgresDataSource, dataSource -> this.getLockCount().longValue()).tags(this.tags).description("Number of locks on the given db").register(registry);
        FunctionCounter.builder("postgres.temp.writes", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.temp.writes", this::getTempBytes)).tags(this.tags).description("The total amount of temporary writes to disk to execute queries").baseUnit("bytes").register(registry);
        this.registerRowCountMetrics(registry);
        this.registerCheckpointMetrics(registry);
    }

    private void registerRowCountMetrics(MeterRegistry registry) {
        FunctionCounter.builder("postgres.rows.fetched", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.fetched", this::getReadCount)).tags(this.tags).description("Number of rows fetched from the db").register(registry);
        FunctionCounter.builder("postgres.rows.inserted", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.inserted", this::getInsertCount)).tags(this.tags).description("Number of rows inserted from the db").register(registry);
        FunctionCounter.builder("postgres.rows.updated", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.updated", this::getUpdateCount)).tags(this.tags).description("Number of rows updated from the db").register(registry);
        FunctionCounter.builder("postgres.rows.deleted", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.deleted", this::getDeleteCount)).tags(this.tags).description("Number of rows deleted from the db").register(registry);
        Gauge.builder("postgres.rows.dead", this.postgresDataSource, dataSource -> this.getDeadTupleCount().longValue()).tags(this.tags).description("Total number of dead rows in the current database").register(registry);
    }

    private void registerCheckpointMetrics(MeterRegistry registry) {
        FunctionCounter.builder("postgres.checkpoints.timed", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.checkpoints.timed", this::getTimedCheckpointsCount)).tags(this.tags).description("Number of checkpoints timed").register(registry);
        FunctionCounter.builder("postgres.checkpoints.requested", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.checkpoints.requested", this::getRequestedCheckpointsCount)).tags(this.tags).description("Number of checkpoints requested").register(registry);
        FunctionCounter.builder("postgres.buffers.checkpoint", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.buffers.checkpoint", this::getBuffersCheckpoint)).tags(this.tags).description("Number of buffers written during checkpoints").register(registry);
        FunctionCounter.builder("postgres.buffers.clean", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.buffers.clean", this::getBuffersClean)).tags(this.tags).description("Number of buffers written by the background writer").register(registry);
        FunctionCounter.builder("postgres.buffers.backend", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.buffers.backend", this::getBuffersBackend)).tags(this.tags).description("Number of buffers written directly by a backend").register(registry);
    }

    private Long getDatabaseSize() {
        return this.runQuery("SELECT pg_database_size('" + this.database + "')");
    }

    private Long getLockCount() {
        return this.runQuery("SELECT count(*) FROM pg_locks l JOIN pg_database d ON l.DATABASE=d.oid WHERE d.datname='" + this.database + "'");
    }

    private Long getConnectionCount() {
        return this.runQuery(this.queryConnectionCount);
    }

    private Long getReadCount() {
        return this.runQuery(this.queryReadCount);
    }

    private Long getInsertCount() {
        return this.runQuery(this.queryInsertCount);
    }

    private Long getTempBytes() {
        return this.runQuery(this.queryTempBytes);
    }

    private Long getUpdateCount() {
        return this.runQuery(this.queryUpdateCount);
    }

    private Long getDeleteCount() {
        return this.runQuery(this.queryDeleteCount);
    }

    private Long getBlockHits() {
        return this.runQuery(this.queryBlockHits);
    }

    private Long getBlockReads() {
        return this.runQuery(this.queryBlockReads);
    }

    private Long getTransactionCount() {
        return this.runQuery(this.queryTransactionCount);
    }

    private Long getDeadTupleCount() {
        return this.runQuery(QUERY_DEAD_TUPLE_COUNT);
    }

    private Long getTimedCheckpointsCount() {
        return this.runQuery(QUERY_TIMED_CHECKPOINTS_COUNT);
    }

    private Long getRequestedCheckpointsCount() {
        return this.runQuery(QUERY_REQUESTED_CHECKPOINTS_COUNT);
    }

    private Long getBuffersClean() {
        return this.runQuery(QUERY_BUFFERS_CLEAN);
    }

    private Long getBuffersBackend() {
        return this.runQuery(QUERY_BUFFERS_BACKEND);
    }

    private Long getBuffersCheckpoint() {
        return this.runQuery(QUERY_BUFFERS_CHECKPOINT);
    }

    Double resettableFunctionalCounter(String functionalCounterKey, DoubleSupplier function) {
        Double result = function.getAsDouble();
        Double previousResult = this.previousValueCacheMap.getOrDefault(functionalCounterKey, 0.0);
        Double beforeResetValue = this.beforeResetValuesCacheMap.getOrDefault(functionalCounterKey, 0.0);
        Double correctedValue = result + beforeResetValue;
        if (correctedValue < previousResult) {
            this.beforeResetValuesCacheMap.put(functionalCounterKey, previousResult);
            correctedValue = previousResult + result;
        }
        this.previousValueCacheMap.put(functionalCounterKey, correctedValue);
        return correctedValue;
    }

    /*
     * Exception decompiling
     */
    private Long runQuery(String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getDBStatQuery(String database, String statName) {
        return SELECT + statName + " FROM pg_stat_database WHERE datname = '" + database + "'";
    }

    private static String getUserTableQuery(String statName) {
        return SELECT + statName + " FROM pg_stat_user_tables";
    }

    private static String getBgWriterQuery(String statName) {
        return SELECT + statName + " FROM pg_stat_bgwriter";
    }
}

