/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.MeterBinder;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullApi;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class ClassLoaderMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public ClassLoaderMetrics() {
        this(Collections.emptyList());
    }

    public ClassLoaderMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
        Gauge.builder("jvm.classes.loaded", classLoadingBean, ClassLoadingMXBean::getLoadedClassCount).tags(this.tags).description("The number of classes that are currently loaded in the Java virtual machine").baseUnit("classes").register(registry);
        FunctionCounter.builder("jvm.classes.unloaded", classLoadingBean, ClassLoadingMXBean::getUnloadedClassCount).tags(this.tags).description("The total number of classes unloaded since the Java virtual machine has started execution").baseUnit("classes").register(registry);
    }
}

