/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm;

import java.io.File;
import java.util.Collections;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.annotation.Incubating;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tags;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.MeterBinder;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullApi;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullFields;

@NonNullApi
@NonNullFields
@Incubating(since="1.1.0")
public class DiskSpaceMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;
    private final File path;
    private final String absolutePath;

    public DiskSpaceMetrics(File path) {
        this(path, Collections.emptyList());
    }

    public DiskSpaceMetrics(File path, Iterable<Tag> tags) {
        this.path = path;
        this.absolutePath = path.getAbsolutePath();
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Tags tagsWithPath = Tags.concat(this.tags, "path", this.absolutePath);
        Gauge.builder("disk.free", this.path, File::getUsableSpace).tags(tagsWithPath).description("Usable space for path").baseUnit("bytes").register(registry);
        Gauge.builder("disk.total", this.path, File::getTotalSpace).tags(tagsWithPath).description("Total space for path").baseUnit("bytes").register(registry);
    }
}

