/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.MeterBinder;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.logging.MetricsTurboFilter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullApi;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.NonNullFields;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.LoggerFactory;

@NonNullApi
@NonNullFields
public class LogbackMetrics
implements MeterBinder,
AutoCloseable {
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    private final Map<MeterRegistry, MetricsTurboFilter> metricsTurboFilters = new ConcurrentHashMap<MeterRegistry, MetricsTurboFilter>();

    public LogbackMetrics() {
        this(Collections.emptyList());
    }

    public LogbackMetrics(Iterable<Tag> tags) {
        this(tags, (LoggerContext)LoggerFactory.getILoggerFactory());
    }

    public LogbackMetrics(Iterable<Tag> tags, LoggerContext context) {
        this.tags = tags;
        this.loggerContext = context;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        MetricsTurboFilter filter = new MetricsTurboFilter(registry, this.tags);
        this.metricsTurboFilters.put(registry, filter);
        this.loggerContext.addTurboFilter((TurboFilter)filter);
    }

    public static void ignoreMetrics(Runnable r) {
        ignoreMetrics.set(true);
        r.run();
        ignoreMetrics.remove();
    }

    @Override
    public void close() {
        for (MetricsTurboFilter metricsTurboFilter : this.metricsTurboFilters.values()) {
            this.loggerContext.getTurboFilterList().remove((Object)metricsTurboFilter);
        }
    }
}

