/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.composite;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Timer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.composite.AbstractCompositeMeter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.HistogramSnapshot;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.pause.PauseDetector;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.noop.NoopTimer;

class CompositeTimer
extends AbstractCompositeMeter<Timer>
implements Timer {
    private final Clock clock;
    private final DistributionStatisticConfig distributionStatisticConfig;
    private final PauseDetector pauseDetector;

    CompositeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(id);
        this.clock = clock;
        this.distributionStatisticConfig = distributionStatisticConfig;
        this.pauseDetector = pauseDetector;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.forEachChild(ds -> ds.record(amount, unit));
    }

    @Override
    public void record(Duration duration) {
        this.forEachChild(ds -> ds.record(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> f) {
        long s2 = this.clock.monotonicTime();
        try {
            T t = f.get();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        long s2 = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s2 = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s2, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return ((Timer)this.firstChild()).count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return ((Timer)this.firstChild()).totalTime(unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return ((Timer)this.firstChild()).max(unit);
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        return ((Timer)this.firstChild()).takeSnapshot();
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return ((Timer)this.firstChild()).baseTimeUnit();
    }

    @Override
    Timer newNoopMeter() {
        return new NoopTimer(this.getId());
    }

    @Override
    Timer registerNewMeter(MeterRegistry registry) {
        Timer.Builder builder = Timer.builder(this.getId().getName()).tags(this.getId().getTagsAsIterable()).description(this.getId().getDescription()).maximumExpectedValue(Duration.ofNanos(this.distributionStatisticConfig.getMaximumExpectedValue())).minimumExpectedValue(Duration.ofNanos(this.distributionStatisticConfig.getMinimumExpectedValue())).publishPercentiles(this.distributionStatisticConfig.getPercentiles()).publishPercentileHistogram(this.distributionStatisticConfig.isPercentileHistogram()).distributionStatisticBufferLength(this.distributionStatisticConfig.getBufferLength()).distributionStatisticExpiry(this.distributionStatisticConfig.getExpiry()).percentilePrecision(this.distributionStatisticConfig.getPercentilePrecision()).pauseDetector(this.pauseDetector);
        long[] slaNanos = this.distributionStatisticConfig.getSlaBoundaries();
        if (slaNanos != null) {
            Duration[] sla = new Duration[slaNanos.length];
            for (int i = 0; i < slaNanos.length; ++i) {
                sla[i] = Duration.ofNanos(slaNanos[i]);
            }
            builder = builder.sla(sla);
        }
        return builder.register(registry);
    }
}

