/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution;

import java.time.Duration;
import java.util.NavigableSet;
import java.util.TreeSet;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.PercentileHistogramBuckets;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal.Mergeable;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public class DistributionStatisticConfig
implements Mergeable<DistributionStatisticConfig> {
    public static final DistributionStatisticConfig DEFAULT = DistributionStatisticConfig.builder().percentilesHistogram(false).percentilePrecision(1).minimumExpectedValue(1L).maximumExpectedValue(Long.MAX_VALUE).expiry(Duration.ofMinutes(2L)).bufferLength(3).build();
    public static final DistributionStatisticConfig NONE = DistributionStatisticConfig.builder().build();
    @Nullable
    private Boolean percentileHistogram;
    @Nullable
    private double[] percentiles;
    @Nullable
    private Integer percentilePrecision;
    @Nullable
    private long[] sla;
    @Nullable
    private Long minimumExpectedValue;
    @Nullable
    private Long maximumExpectedValue;
    @Nullable
    private Duration expiry;
    @Nullable
    private Integer bufferLength;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DistributionStatisticConfig merge(DistributionStatisticConfig parent) {
        return DistributionStatisticConfig.builder().percentilesHistogram(this.percentileHistogram == null ? parent.percentileHistogram : this.percentileHistogram).percentiles(this.percentiles == null ? parent.percentiles : this.percentiles).sla(this.sla == null ? parent.sla : this.sla).percentilePrecision(this.percentilePrecision == null ? parent.percentilePrecision : this.percentilePrecision).minimumExpectedValue(this.minimumExpectedValue == null ? parent.minimumExpectedValue : this.minimumExpectedValue).maximumExpectedValue(this.maximumExpectedValue == null ? parent.maximumExpectedValue : this.maximumExpectedValue).expiry(this.expiry == null ? parent.expiry : this.expiry).bufferLength(this.bufferLength == null ? parent.bufferLength : this.bufferLength).build();
    }

    public NavigableSet<Long> getHistogramBuckets(boolean supportsAggregablePercentiles) {
        TreeSet<Long> buckets = new TreeSet<Long>();
        if (this.percentileHistogram != null && this.percentileHistogram.booleanValue() && supportsAggregablePercentiles) {
            buckets.addAll(PercentileHistogramBuckets.buckets(this));
            buckets.add(this.minimumExpectedValue);
            buckets.add(this.maximumExpectedValue);
        }
        if (this.sla != null) {
            for (long slaBoundary : this.sla) {
                buckets.add(slaBoundary);
            }
        }
        return buckets;
    }

    @Nullable
    public Boolean isPercentileHistogram() {
        return this.percentileHistogram;
    }

    @Nullable
    public double[] getPercentiles() {
        return this.percentiles;
    }

    @Nullable
    public Integer getPercentilePrecision() {
        return this.percentilePrecision;
    }

    @Nullable
    public Long getMinimumExpectedValue() {
        return this.minimumExpectedValue;
    }

    @Nullable
    public Long getMaximumExpectedValue() {
        return this.maximumExpectedValue;
    }

    @Nullable
    public Duration getExpiry() {
        return this.expiry;
    }

    @Nullable
    public Integer getBufferLength() {
        return this.bufferLength;
    }

    @Nullable
    public long[] getSlaBoundaries() {
        return this.sla;
    }

    public boolean isPublishingPercentiles() {
        return this.percentiles != null && this.percentiles.length > 0;
    }

    public boolean isPublishingHistogram() {
        return this.percentileHistogram != null && this.percentileHistogram != false || this.sla != null && this.sla.length > 0;
    }

    static /* synthetic */ double[] access$102(DistributionStatisticConfig x0, double[] x1) {
        x0.percentiles = x1;
        return x1;
    }

    static /* synthetic */ long[] access$302(DistributionStatisticConfig x0, long[] x1) {
        x0.sla = x1;
        return x1;
    }

    public static class Builder {
        private final DistributionStatisticConfig config = new DistributionStatisticConfig();

        public Builder percentilesHistogram(@Nullable Boolean enabled) {
            this.config.percentileHistogram = enabled;
            return this;
        }

        public Builder percentiles(double ... percentiles) {
            DistributionStatisticConfig.access$102(this.config, percentiles);
            return this;
        }

        public Builder percentilePrecision(@Nullable Integer digitsOfPrecision) {
            this.config.percentilePrecision = digitsOfPrecision;
            return this;
        }

        public Builder sla(long ... sla) {
            DistributionStatisticConfig.access$302(this.config, sla);
            return this;
        }

        public Builder minimumExpectedValue(@Nullable Long min2) {
            this.config.minimumExpectedValue = min2;
            return this;
        }

        public Builder maximumExpectedValue(@Nullable Long max) {
            this.config.maximumExpectedValue = max;
            return this;
        }

        public Builder expiry(@Nullable Duration expiry) {
            this.config.expiry = expiry;
            return this;
        }

        public Builder bufferLength(@Nullable Integer bufferLength) {
            this.config.bufferLength = bufferLength;
            return this;
        }

        public DistributionStatisticConfig build() {
            return this.config;
        }
    }
}

