/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.AbstractTimeWindowHistogram;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.PercentileHistogramBuckets;

public class TimeWindowFixedBoundaryHistogram
extends AbstractTimeWindowHistogram<FixedBoundaryHistogram, Void> {
    private final long[] buckets;

    public TimeWindowFixedBoundaryHistogram(Clock clock, DistributionStatisticConfig config, boolean supportsAggregablePercentiles) {
        super(clock, config, FixedBoundaryHistogram.class, supportsAggregablePercentiles);
        NavigableSet<Long> histogramBuckets = this.distributionStatisticConfig.getHistogramBuckets(supportsAggregablePercentiles);
        Boolean percentileHistogram = this.distributionStatisticConfig.isPercentileHistogram();
        if (percentileHistogram != null && percentileHistogram.booleanValue()) {
            histogramBuckets.addAll(PercentileHistogramBuckets.buckets(this.distributionStatisticConfig));
        }
        this.buckets = histogramBuckets.stream().filter(Objects::nonNull).mapToLong(Long::longValue).toArray();
        this.initRingBuffer();
    }

    @Override
    FixedBoundaryHistogram newBucket() {
        return new FixedBoundaryHistogram();
    }

    @Override
    void recordLong(FixedBoundaryHistogram bucket, long value) {
        bucket.record(value);
    }

    @Override
    final void recordDouble(FixedBoundaryHistogram bucket, double value) {
        this.recordLong(bucket, (long)Math.ceil(value));
    }

    @Override
    void resetBucket(FixedBoundaryHistogram bucket) {
        bucket.reset();
    }

    Void newAccumulatedHistogram(FixedBoundaryHistogram[] ringBuffer) {
        return null;
    }

    @Override
    void accumulate() {
    }

    @Override
    void resetAccumulatedHistogram() {
    }

    @Override
    double valueAtPercentile(double percentile) {
        return 0.0;
    }

    @Override
    double countAtValue(long value) {
        return ((FixedBoundaryHistogram)this.currentHistogram()).countAtValue(value);
    }

    @Override
    void outputSummary(PrintStream printStream, double bucketScaling) {
        printStream.format("%14s %10s\n\n", "Bucket", "TotalCount");
        String bucketFormatString = "%14.1f %10d\n";
        for (int i = 0; i < this.buckets.length; ++i) {
            printStream.format(Locale.US, bucketFormatString, (double)this.buckets[i] / bucketScaling, ((FixedBoundaryHistogram)this.currentHistogram()).values[i].get());
        }
        printStream.write(10);
    }

    class FixedBoundaryHistogram {
        final AtomicLong[] values;

        FixedBoundaryHistogram() {
            this.values = new AtomicLong[TimeWindowFixedBoundaryHistogram.this.buckets.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = new AtomicLong(0L);
            }
        }

        long countAtValue(long value) {
            int index = Arrays.binarySearch(TimeWindowFixedBoundaryHistogram.this.buckets, value);
            if (index < 0) {
                return 0L;
            }
            long count = 0L;
            for (int i = 0; i <= index; ++i) {
                count += this.values[i].get();
            }
            return count;
        }

        void reset() {
            for (AtomicLong value : this.values) {
                value.set(0L);
            }
        }

        void record(long value) {
            int index = this.leastLessThanOrEqualTo(value);
            if (index > -1) {
                this.values[index].incrementAndGet();
            }
        }

        int leastLessThanOrEqualTo(long key) {
            int low = 0;
            int high = TimeWindowFixedBoundaryHistogram.this.buckets.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                if (TimeWindowFixedBoundaryHistogram.this.buckets[mid] < key) {
                    low = mid + 1;
                    continue;
                }
                if (TimeWindowFixedBoundaryHistogram.this.buckets[mid] > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low < TimeWindowFixedBoundaryHistogram.this.buckets.length ? low : -1;
        }
    }
}

