/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import ru.yandex.clickhouse.jdbcbridge.internal.metrics.Metric;
import ru.yandex.clickhouse.jdbcbridge.internal.metrics.MetricRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Counter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.DistributionSummary;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.LongTaskTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Measurement;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Statistic;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Timer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.config.NamingConvention;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.HistogramGauges;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.pause.PauseDetector;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardClock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardFunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardFunctionTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardGauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard.DropwizardTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal.DefaultMeter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.util.HierarchicalNameMapper;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public abstract class DropwizardMeterRegistry
extends MeterRegistry {
    private final MetricRegistry registry;
    private final HierarchicalNameMapper nameMapper;
    private final DropwizardClock dropwizardClock;
    private final DropwizardConfig dropwizardConfig;

    public DropwizardMeterRegistry(DropwizardConfig config, MetricRegistry registry, HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        this.dropwizardConfig = config;
        this.dropwizardClock = new DropwizardClock(clock);
        this.registry = registry;
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase);
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        ru.yandex.clickhouse.jdbcbridge.internal.metrics.Meter meter = new ru.yandex.clickhouse.jdbcbridge.internal.metrics.Meter((ru.yandex.clickhouse.jdbcbridge.internal.metrics.Clock)this.dropwizardClock);
        this.registry.register(this.hierarchicalName(id), (Metric)meter);
        return new DropwizardCounter(id, meter);
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        WeakReference ref = new WeakReference(obj);
        ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge gauge = () -> {
            Object obj2 = ref.get();
            if (obj2 != null) {
                return valueFunction.applyAsDouble(obj2);
            }
            return this.nullGaugeValue();
        };
        this.registry.register(this.hierarchicalName(id), (Metric)gauge);
        return new DropwizardGauge(id, (ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge<Double>)gauge);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        DropwizardTimer timer = new DropwizardTimer(id, this.registry.timer(this.hierarchicalName(id)), this.clock, distributionStatisticConfig, pauseDetector);
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        DropwizardDistributionSummary summary = new DropwizardDistributionSummary(id, this.clock, this.registry.histogram(this.hierarchicalName(id)), distributionStatisticConfig, scale);
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock);
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.ACTIVE_TASKS)), (Metric)((ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge)ltt::activeTasks));
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.DURATION)), (Metric)((ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge)() -> ltt.duration(TimeUnit.NANOSECONDS)));
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        DropwizardFunctionTimer<T> ft = new DropwizardFunctionTimer<T>(id, this.clock, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
        this.registry.register(this.hierarchicalName(id), (Metric)ft.getDropwizardMeter());
        return ft;
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        DropwizardFunctionCounter<T> fc = new DropwizardFunctionCounter<T>(id, this.clock, obj, countFunction);
        this.registry.register(this.hierarchicalName(id), (Metric)fc.getDropwizardMeter());
        return fc;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge cfr_ignored_0 = (ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge)this.registry.register(this.hierarchicalName(id.withTag(ms.getStatistic())), (Metric)((ru.yandex.clickhouse.jdbcbridge.internal.metrics.Gauge)ms::getValue));
        });
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private String hierarchicalName(Meter.Id id) {
        return this.nameMapper.toHierarchicalName(id, this.config().namingConvention());
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.dropwizardConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    protected abstract Double nullGaugeValue();
}

