/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.dropwizard;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import ru.yandex.clickhouse.jdbcbridge.internal.metrics.Timer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.AbstractTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.TimeWindowMax;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.pause.PauseDetector;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.util.TimeUtils;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final TimeWindowMax max;

    DropwizardTimer(Meter.Id id, Timer impl, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(id, clock, distributionStatisticConfig, pauseDetector, TimeUnit.MILLISECONDS, false);
        this.impl = impl;
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.impl.update(amount, unit);
            long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
            this.max.record(nanoAmount, TimeUnit.NANOSECONDS);
            this.totalTime.addAndGet(nanoAmount);
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.get(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }
}

