/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal;

import java.util.concurrent.Executor;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tags;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Timer;

public class TimedExecutor
implements Executor {
    private final MeterRegistry registry;
    private final Executor delegate;
    private final Timer executionTimer;
    private final Timer idleTimer;

    public TimedExecutor(MeterRegistry registry, Executor delegate, String executorName, Iterable<Tag> tags) {
        this.registry = registry;
        this.delegate = delegate;
        this.executionTimer = registry.timer("executor.execution", Tags.concat(tags, "name", executorName));
        this.idleTimer = registry.timer("executor.idle", Tags.concat(tags, "name", executorName));
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(new TimedRunnable(command));
    }

    class TimedRunnable
    implements Runnable {
        private final Runnable command;
        private final Timer.Sample idleSample;

        public TimedRunnable(Runnable command) {
            this.command = command;
            this.idleSample = Timer.start(TimedExecutor.this.registry);
        }

        @Override
        public void run() {
            this.idleSample.stop(TimedExecutor.this.idleTimer);
            Timer.Sample executionSample = Timer.start(TimedExecutor.this.registry);
            try {
                this.command.run();
            }
            finally {
                executionSample.stop(TimedExecutor.this.executionTimer);
            }
        }
    }
}

