/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.push;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.push.PushRegistryConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public abstract class PushMeterRegistry
extends MeterRegistry {
    private final PushRegistryConfig config;
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;

    protected PushMeterRegistry(PushRegistryConfig config, Clock clock) {
        super(clock);
        this.config = config;
    }

    protected abstract void publish();

    @Deprecated
    public final void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void start(ThreadFactory threadFactory) {
        if (this.scheduledExecutorService != null) {
            this.stop();
        }
        if (this.config.enabled()) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.scheduledExecutorService.scheduleAtFixedRate(this::publish, this.config.step().toMillis(), this.config.step().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void close() {
        if (this.config.enabled()) {
            this.publish();
        }
        this.stop();
        super.close();
    }
}

