/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Counter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.DistributionSummary;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.LongTaskTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tags;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.TimeGauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Timer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public final class Search {
    private final MeterRegistry registry;
    private final List<Tag> tags = new ArrayList<Tag>();
    private Predicate<String> nameMatches = n -> true;
    private final Set<String> requiredTagKeys = new HashSet<String>();

    private Search(MeterRegistry registry) {
        this.registry = registry;
    }

    public Search name(String exactName) {
        return this.name((String n) -> n.equals(exactName));
    }

    public Search name(@Nullable Predicate<String> nameMatches) {
        if (nameMatches != null) {
            this.nameMatches = nameMatches;
        }
        return this;
    }

    public Search tags(Iterable<Tag> tags) {
        tags.forEach(this.tags::add);
        return this;
    }

    public Search tags(String ... tags) {
        return this.tags(Tags.of(tags));
    }

    public Search tag(String tagKey, String tagValue) {
        return this.tags(Tags.of(tagKey, tagValue));
    }

    public Search tagKeys(String ... tagKeys) {
        this.requiredTagKeys.addAll(Arrays.asList(tagKeys));
        return this;
    }

    @Nullable
    public Timer timer() {
        return this.findOne(Timer.class);
    }

    @Nullable
    public Counter counter() {
        return this.findOne(Counter.class);
    }

    @Nullable
    public Gauge gauge() {
        return this.findOne(Gauge.class);
    }

    @Nullable
    public FunctionCounter functionCounter() {
        return this.findOne(FunctionCounter.class);
    }

    @Nullable
    public TimeGauge timeGauge() {
        return this.findOne(TimeGauge.class);
    }

    @Nullable
    public FunctionTimer functionTimer() {
        return this.findOne(FunctionTimer.class);
    }

    @Nullable
    public DistributionSummary summary() {
        return this.findOne(DistributionSummary.class);
    }

    @Nullable
    public LongTaskTimer longTaskTimer() {
        return this.findOne(LongTaskTimer.class);
    }

    @Nullable
    public Meter meter() {
        return this.findOne(Meter.class);
    }

    @Nullable
    private <M extends Meter> M findOne(Class<M> clazz) {
        return (M)((Meter)this.meterStream().filter(clazz::isInstance).findAny().map(clazz::cast).orElse(null));
    }

    public Collection<Meter> meters() {
        return this.meterStream().collect(Collectors.toList());
    }

    private Stream<Meter> meterStream() {
        Stream<Meter> meterStream = this.registry.getMeters().stream().filter(m3 -> this.nameMatches.test(m3.getId().getName()));
        if (!this.tags.isEmpty() || !this.requiredTagKeys.isEmpty()) {
            meterStream = meterStream.filter(m3 -> {
                boolean requiredKeysPresent = true;
                if (!this.requiredTagKeys.isEmpty()) {
                    ArrayList tagKeys = new ArrayList();
                    m3.getId().getTags().forEach(t -> tagKeys.add(t.getKey()));
                    requiredKeysPresent = tagKeys.containsAll(this.requiredTagKeys);
                }
                return requiredKeysPresent && m3.getId().getTags().containsAll(this.tags);
            });
        }
        return meterStream;
    }

    public Collection<Counter> counters() {
        return this.findAll(Counter.class);
    }

    public Collection<Gauge> gauges() {
        return this.findAll(Gauge.class);
    }

    public Collection<Timer> timers() {
        return this.findAll(Timer.class);
    }

    public Collection<DistributionSummary> summaries() {
        return this.findAll(DistributionSummary.class);
    }

    public Collection<LongTaskTimer> longTaskTimers() {
        return this.findAll(LongTaskTimer.class);
    }

    public Collection<FunctionCounter> functionCounters() {
        return this.findAll(FunctionCounter.class);
    }

    public Collection<FunctionTimer> functionTimers() {
        return this.findAll(FunctionTimer.class);
    }

    public Collection<TimeGauge> timeGauges() {
        return this.findAll(TimeGauge.class);
    }

    private <M extends Meter> Collection<M> findAll(Class<M> clazz) {
        return this.meterStream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static Search in(MeterRegistry registry) {
        return new Search(registry);
    }
}

