/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step;

import java.util.Arrays;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.AbstractDistributionSummary;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Measurement;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Statistic;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.TimeWindowMax;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepDouble;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepLong;

public class StepDistributionSummary
extends AbstractDistributionSummary {
    private final StepLong count;
    private final StepDouble total;
    private final TimeWindowMax max;

    @Deprecated
    public StepDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        this(id, clock, distributionStatisticConfig, scale, false);
    }

    @Deprecated
    public StepDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        this(id, clock, distributionStatisticConfig, scale, distributionStatisticConfig.getExpiry().toMillis(), supportsAggregablePercentiles);
    }

    public StepDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, long stepMillis, boolean supportsAggregablePercentiles) {
        super(id, clock, distributionStatisticConfig, scale, supportsAggregablePercentiles);
        this.count = new StepLong(clock, stepMillis);
        this.total = new StepDouble(clock, stepMillis);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(double amount) {
        this.count.getCurrent().add(1L);
        this.total.getCurrent().add(amount);
        this.max.record(amount);
    }

    @Override
    public long count() {
        return (long)this.count.poll();
    }

    @Override
    public double totalAmount() {
        return this.total.poll();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL), new Measurement(this::max, Statistic.MAX));
    }
}

