/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepDouble;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepLong;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.util.TimeUtils;

public class StepFunctionTimer<T>
implements FunctionTimer {
    private final Meter.Id id;
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnit;
    private final TimeUnit baseTimeUnit;
    private volatile long lastCount = 0L;
    private volatile double lastTime = 0.0;
    private StepLong count;
    private StepDouble total;

    public StepFunctionTimer(Meter.Id id, Clock clock, long stepMillis, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit, TimeUnit baseTimeUnit) {
        this.id = id;
        this.ref = new WeakReference<T>(obj);
        this.countFunction = countFunction;
        this.totalTimeFunction = totalTimeFunction;
        this.totalTimeFunctionUnit = totalTimeFunctionUnit;
        this.baseTimeUnit = baseTimeUnit;
        this.count = new StepLong(clock, stepMillis);
        this.total = new StepDouble(clock, stepMillis);
    }

    @Override
    public double count() {
        Object obj2 = this.ref.get();
        if (obj2 != null) {
            long prevLast = this.lastCount;
            this.lastCount = Math.max(this.countFunction.applyAsLong(obj2), 0L);
            this.count.getCurrent().add(this.lastCount - prevLast);
        }
        return this.count.poll();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        Object obj2 = this.ref.get();
        if (obj2 != null) {
            double prevLast = this.lastTime;
            this.lastTime = Math.max(TimeUtils.convert(this.totalTimeFunction.applyAsDouble(obj2), this.totalTimeFunctionUnit, unit), 0.0);
            this.total.getCurrent().add(this.lastTime - prevLast);
        }
        return this.total.poll();
    }

    @Override
    public Meter.Id getId() {
        return this.id;
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public Meter.Type type() {
        return Meter.Type.TIMER;
    }
}

