/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step;

import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Counter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.DistributionSummary;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.FunctionTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Gauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.LongTaskTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Measurement;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Timer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.HistogramGauges;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.pause.PauseDetector;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal.DefaultGauge;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.internal.DefaultMeter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.push.PushMeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepDistributionSummary;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepFunctionCounter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepFunctionTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepRegistryConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.step.StepTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public abstract class StepMeterRegistry
extends PushMeterRegistry {
    private final StepRegistryConfig config;

    public StepMeterRegistry(StepRegistryConfig config, Clock clock) {
        super(config, clock);
        this.config = config;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge<T>(id, obj, valueFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new DefaultLongTaskTimer(id, this.clock);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        StepTimer timer = new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        StepDistributionSummary summary = new StepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis(), false);
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

