/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.ipc.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.Map;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.util.IOUtils;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.ipc.http.HttpSender;

public class HttpUrlConnectionSender
implements HttpSender {
    private final int connectTimeoutMs;
    private final int readTimeoutMs;

    public HttpUrlConnectionSender(Duration connectTimeout, Duration readTimeout) {
        this.connectTimeoutMs = (int)connectTimeout.toMillis();
        this.readTimeoutMs = (int)readTimeout.toMillis();
    }

    public HttpUrlConnectionSender() {
        this.connectTimeoutMs = 1000;
        this.readTimeoutMs = 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public HttpSender.Response send(HttpSender.Request request) throws IOException {
        HttpURLConnection con = null;
        try {
            void var4_11;
            con = (HttpURLConnection)request.getUrl().openConnection();
            con.setConnectTimeout(this.connectTimeoutMs);
            con.setReadTimeout(this.readTimeoutMs);
            con.setRequestMethod(request.getMethod().toString());
            for (Map.Entry<String, String> entry : request.getRequestHeaders().entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
            con.setDoOutput(true);
            Throwable throwable = null;
            try (OutputStream os = con.getOutputStream();){
                os.write(request.getEntity());
                os.flush();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            int status = con.getResponseCode();
            Object var4_8 = null;
            try {
                if (con.getErrorStream() != null) {
                    String string = IOUtils.toString(con.getErrorStream());
                } else if (con.getInputStream() != null) {
                    String string = IOUtils.toString(con.getInputStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HttpSender.Response response = new HttpSender.Response(status, (String)var4_11);
            return response;
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }
}

