/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.ipc.http;

import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.ipc.http.HttpSender;

public class OkHttpSender
implements HttpSender {
    private final OkHttpClient client;

    public OkHttpSender(OkHttpClient client) {
        this.client = client;
    }

    public OkHttpSender() {
        this(new OkHttpClient());
    }

    @Override
    public HttpSender.Response send(HttpSender.Request request) throws Throwable {
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl());
        for (Map.Entry<String, String> requestHeader : request.getRequestHeaders().entrySet()) {
            requestBuilder.addHeader(requestHeader.getKey(), requestHeader.getValue());
        }
        if (request.getEntity().length > 0) {
            String contentType = request.getRequestHeaders().get("Content-Type");
            if (contentType == null) {
                contentType = "application/json";
            }
            RequestBody body = RequestBody.create((MediaType)MediaType.get((String)(contentType + "; charset=utf-8")), (byte[])request.getEntity());
            requestBuilder.method(request.getMethod().toString(), body);
        } else if (HttpMethod.requiresRequestBody((String)request.getMethod().toString())) {
            RequestBody body = RequestBody.create((MediaType)MediaType.get((String)"text/plain; charset=utf-8"), (byte[])request.getEntity());
            requestBuilder.method(request.getMethod().toString(), body);
        } else {
            requestBuilder.method(request.getMethod().toString(), null);
        }
        Response response = this.client.newCall(requestBuilder.build()).execute();
        return new HttpSender.Response(response.code(), response.body() == null ? null : response.body().string());
    }
}

