/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.micrometer.prometheus;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.AbstractTimer;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Clock;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.CountAtBucket;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.Histogram;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.HistogramSnapshot;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.TimeWindowMax;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.distribution.pause.PauseDetector;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.util.TimeUtils;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.lang.Nullable;

public class PrometheusTimer
extends AbstractTimer {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final TimeWindowMax max;
    @Nullable
    private final Histogram histogram;

    PrometheusTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(false).sla(new long[0]).build().merge(distributionStatisticConfig), pauseDetector, TimeUnit.SECONDS, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.histogram = distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(1).build().merge(distributionStatisticConfig), true) : null;
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.max.record(nanoAmount, TimeUnit.NANOSECONDS);
        if (this.histogram != null) {
            this.histogram.recordLong(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram == null ? EMPTY_HISTOGRAM : this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.histogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(TimeUnit.SECONDS), snapshot.max(TimeUnit.SECONDS), snapshot.percentileValues(), this.histogramCounts(), snapshot::outputSummary);
    }
}

