/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.channel;

import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufAllocator;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.CompositeByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.Unpooled;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.AbstractCoalescingBufferQueue;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPromise;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.ObjectUtil;

public final class CoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final Channel channel;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int initSize) {
        this(channel, initSize, false);
    }

    public CoalescingBufferQueue(Channel channel, int initSize, boolean updateWritability) {
        super(updateWritability ? channel : null, initSize);
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    public ByteBuf remove(int bytes, ChannelPromise aggregatePromise) {
        return this.remove(this.channel.alloc(), bytes, aggregatePromise);
    }

    public void releaseAndFailAll(Throwable cause) {
        this.releaseAndFailAll(this.channel, cause);
    }

    @Override
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        if (cumulation instanceof CompositeByteBuf) {
            CompositeByteBuf composite = (CompositeByteBuf)cumulation;
            composite.addComponent(true, next);
            return composite;
        }
        return this.composeIntoComposite(alloc, cumulation, next);
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return Unpooled.EMPTY_BUFFER;
    }
}

