/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.channel;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPromise;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.EventLoop;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.EventLoopGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.NettyRuntime;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.DefaultThreadFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.EventExecutorChooserFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.concurrent.MultithreadEventExecutorGroup;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.SystemPropertyUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.logging.InternalLogger;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.logging.InternalLoggerFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("ru.yandex.clickhouse.jdbcbridge.internal.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, Executor executor, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, executor, args);
    }

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    protected MultithreadEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, executor, chooserFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    protected abstract EventLoop newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return this.next().register(promise);
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

