/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.oio;

import java.io.IOException;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufAllocator;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.Channel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelMetadata;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelOption;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelOutboundBuffer;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelPipeline;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.FileRegion;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.RecvByteBufAllocator;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.oio.AbstractOioChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.socket.ChannelInputShutdownEvent;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.socket.ChannelInputShutdownReadComplete;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.StringUtil;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';

    protected AbstractOioByteChannel(Channel parent) {
        super(parent);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean isInputShutdown();

    protected abstract ChannelFuture shutdownInput();

    private void closeOnRead(ChannelPipeline pipeline) {
        if (this.isOpen()) {
            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                this.shutdownInput();
                pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.unsafe().close(this.unsafe().voidPromise());
            }
            pipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, RecvByteBufAllocator.Handle allocHandle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                pipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        allocHandle.readComplete();
        pipeline.fireChannelReadComplete();
        pipeline.fireExceptionCaught(cause);
        if (close || cause instanceof IOException) {
            this.closeOnRead(pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead() {
        ChannelConfig config = this.config();
        if (this.isInputShutdown() || !this.readPending) {
            return;
        }
        this.readPending = false;
        ChannelPipeline pipeline = this.pipeline();
        ByteBufAllocator allocator = config.getAllocator();
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        allocHandle.reset(config);
        ByteBuf byteBuf = null;
        boolean close = false;
        boolean readData = false;
        try {
            byteBuf = allocHandle.allocate(allocator);
            do {
                int maxCapacity;
                allocHandle.lastBytesRead(this.doReadBytes(byteBuf));
                if (allocHandle.lastBytesRead() <= 0) {
                    if (byteBuf.isReadable()) break;
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl = close = allocHandle.lastBytesRead() < 0;
                    if (!close) break;
                    this.readPending = false;
                    break;
                }
                readData = true;
                int available = this.available();
                if (available <= 0) break;
                if (byteBuf.isWritable()) continue;
                int capacity = byteBuf.capacity();
                if (capacity == (maxCapacity = byteBuf.maxCapacity())) {
                    allocHandle.incMessagesRead(1);
                    this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                    byteBuf = allocHandle.allocate(allocator);
                    continue;
                }
                int writerIndex = byteBuf.writerIndex();
                if (writerIndex + available > maxCapacity) {
                    byteBuf.capacity(maxCapacity);
                    continue;
                }
                byteBuf.ensureWritable(available);
            } while (allocHandle.continueReading());
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
                byteBuf = null;
            }
            if (readData) {
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
            }
            if (close) {
                this.closeOnRead(pipeline);
            }
        }
        catch (Throwable t) {
            this.handleReadException(pipeline, byteBuf, t, close, allocHandle);
        }
        finally {
            if (this.readPending || config.isAutoRead() || !readData && this.isActive()) {
                this.read();
            }
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        while ((msg = in.current()) != null) {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                int readableBytes = buf.readableBytes();
                while (readableBytes > 0) {
                    this.doWriteBytes(buf);
                    int newReadableBytes = buf.readableBytes();
                    in.progress(readableBytes - newReadableBytes);
                    readableBytes = newReadableBytes;
                }
                in.remove();
                continue;
            }
            if (msg instanceof FileRegion) {
                FileRegion region = (FileRegion)msg;
                long transferred = region.transferred();
                this.doWriteFileRegion(region);
                in.progress(region.transferred() - transferred);
                in.remove();
                continue;
            }
            in.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg)));
        }
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) throws Exception {
        if (msg instanceof ByteBuf || msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteFileRegion(FileRegion var1) throws Exception;
}

