/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.compression;

import java.util.List;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.CompositeByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.embedded.EmbeddedChannel;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.CodecException;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.compression.ZlibCodecFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.compression.ZlibWrapper;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.WebSocketFrame;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.ObjectUtil;

abstract class DeflateEncoder
extends WebSocketExtensionEncoder {
    private final int compressionLevel;
    private final int windowSize;
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionEncoderFilter;
    private EmbeddedChannel encoder;

    DeflateEncoder(int compressionLevel, int windowSize, boolean noContext, WebSocketExtensionFilter extensionEncoderFilter) {
        this.compressionLevel = compressionLevel;
        this.windowSize = windowSize;
        this.noContext = noContext;
        this.extensionEncoderFilter = ObjectUtil.checkNotNull(extensionEncoderFilter, "extensionEncoderFilter");
    }

    protected WebSocketExtensionFilter extensionEncoderFilter() {
        return this.extensionEncoderFilter;
    }

    protected abstract int rsv(WebSocketFrame var1);

    protected abstract boolean removeFrameTail(WebSocketFrame var1);

    @Override
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        WebSocketFrame outMsg;
        ByteBuf compressedContent;
        if (msg.content().isReadable()) {
            compressedContent = this.compressContent(ctx, msg);
        } else if (msg.isFinalFragment()) {
            compressedContent = PerMessageDeflateDecoder.EMPTY_DEFLATE_BLOCK.duplicate();
        } else {
            throw new CodecException("cannot compress content buffer");
        }
        if (msg instanceof TextWebSocketFrame) {
            outMsg = new TextWebSocketFrame(msg.isFinalFragment(), this.rsv(msg), compressedContent);
        } else if (msg instanceof BinaryWebSocketFrame) {
            outMsg = new BinaryWebSocketFrame(msg.isFinalFragment(), this.rsv(msg), compressedContent);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            outMsg = new ContinuationWebSocketFrame(msg.isFinalFragment(), this.rsv(msg), compressedContent);
        } else {
            throw new CodecException("unexpected frame type: " + msg.getClass().getName());
        }
        out.add(outMsg);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.handlerRemoved(ctx);
    }

    private ByteBuf compressContent(ChannelHandlerContext ctx, WebSocketFrame msg) {
        ByteBuf compressedContent;
        ByteBuf partCompressedContent;
        if (this.encoder == null) {
            this.encoder = new EmbeddedChannel(ZlibCodecFactory.newZlibEncoder(ZlibWrapper.NONE, this.compressionLevel, this.windowSize, 8));
        }
        this.encoder.writeOutbound(msg.content().retain());
        CompositeByteBuf fullCompressedContent = ctx.alloc().compositeBuffer();
        while ((partCompressedContent = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!partCompressedContent.isReadable()) {
                partCompressedContent.release();
                continue;
            }
            fullCompressedContent.addComponent(true, partCompressedContent);
        }
        if (fullCompressedContent.numComponents() <= 0) {
            fullCompressedContent.release();
            throw new CodecException("cannot read compressed buffer");
        }
        if (msg.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        if (this.removeFrameTail(msg)) {
            int realLength = fullCompressedContent.readableBytes() - PerMessageDeflateDecoder.FRAME_TAIL.readableBytes();
            compressedContent = fullCompressedContent.slice(0, realLength);
        } else {
            compressedContent = fullCompressedContent;
        }
        return compressedContent;
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.encoder.finishAndReleaseAll();
            this.encoder = null;
        }
    }
}

