/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.protobuf;

import java.util.List;
import ru.yandex.clickhouse.jdbcbridge.internal.google.protobuf.nano.MessageNano;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBuf;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.buffer.ByteBufUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.codec.MessageToMessageDecoder;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array = ByteBufUtil.getBytes(msg, msg.readerIndex(), length, false);
            offset = 0;
        }
        MessageNano prototype = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array, (int)offset, (int)length));
    }
}

