/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ipfilter.IpFilterRule;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ipfilter.IpFilterRuleType;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this.rules = ObjectUtil.checkNotNull(rules, "rules");
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

