/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelFutureListener;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandler;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.channel.ChannelHandlerContext;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.ConcurrentSet;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

