/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.yandex.clickhouse.jdbcbridge.internal.log4j.LogManager;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.ILoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.helpers.Util;
import ru.yandex.clickhouse.jdbcbridge.internal.slf4j.impl.Log4jLoggerAdapter;

public class Log4jLoggerFactory
implements ILoggerFactory {
    private static final String LOG4J_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#log4jDelegationLoop";
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Log4jLoggerFactory() {
        LogManager.getRootLogger();
    }

    public Logger getLogger(String name) {
        Logger slf4jLogger = (Logger)this.loggerMap.get(name);
        if (slf4jLogger != null) {
            return slf4jLogger;
        }
        ru.yandex.clickhouse.jdbcbridge.internal.log4j.Logger log4jLogger = name.equalsIgnoreCase("ROOT") ? LogManager.getRootLogger() : LogManager.getLogger(name);
        Log4jLoggerAdapter newInstance = new Log4jLoggerAdapter(log4jLogger);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    static {
        try {
            Class.forName("ru.yandex.clickhouse.jdbcbridge.internal.log4j.Log4jLoggerFactory");
            String part1 = "Detected both log4j-over-slf4j.jar AND bound slf4j-log4j12.jar on the class path, preempting StackOverflowError. ";
            String part2 = "See also http://www.slf4j.org/codes.html#log4jDelegationLoop for more details.";
            Util.report(part1);
            Util.report(part2);
            throw new IllegalStateException(part1 + part2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

