/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config;

import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.DataObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

@DataObject
public class ConfigChange {
    private JsonObject previousConfiguration;
    private JsonObject newConfiguration;

    public ConfigChange(JsonObject prevConf, JsonObject newConf) {
        this.setPreviousConfiguration(prevConf);
        this.setNewConfiguration(newConf);
    }

    public JsonObject getPreviousConfiguration() {
        return this.previousConfiguration;
    }

    public ConfigChange setPreviousConfiguration(JsonObject conf) {
        this.previousConfiguration = conf == null ? new JsonObject() : conf;
        return this;
    }

    public JsonObject getNewConfiguration() {
        return this.newConfiguration;
    }

    public ConfigChange setNewConfiguration(JsonObject conf) {
        this.newConfiguration = conf == null ? new JsonObject() : conf;
        return this;
    }

    public ConfigChange() {
        this.newConfiguration = new JsonObject();
        this.previousConfiguration = new JsonObject();
    }

    public ConfigChange(ConfigChange other) {
        this.previousConfiguration = other.previousConfiguration.copy();
        this.newConfiguration = other.newConfiguration.copy();
    }

    public ConfigChange(JsonObject json) {
        Objects.requireNonNull(json);
        this.setNewConfiguration(json.getJsonObject("newConfiguration", new JsonObject()));
        this.setPreviousConfiguration(json.getJsonObject("previousConfiguration", new JsonObject()));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("newConfiguration", this.newConfiguration);
        json.put("previousConfiguration", this.previousConfiguration);
        return json;
    }
}

