/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigProcessor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigStore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;

public class ConfigurationProvider {
    private final JsonObject configuration;
    private final boolean optional;
    private final ConfigStore store;
    private final ConfigProcessor processor;
    private final Logger logger;

    public ConfigurationProvider(ConfigStore store, ConfigProcessor processor, JsonObject config, boolean optional) {
        this.store = store;
        this.processor = processor;
        this.optional = optional;
        this.configuration = config == null ? new JsonObject() : config;
        this.logger = LoggerFactory.getLogger("ConfigurationProvider#" + store);
    }

    void get(Vertx vertx, Handler<AsyncResult<JsonObject>> completionHandler) {
        this.store.get(maybeBuffer -> {
            if (maybeBuffer.failed()) {
                if (this.optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Unable to retrieve the configuration", maybeBuffer.cause());
                    }
                    completionHandler.handle(Future.succeededFuture(new JsonObject()));
                } else {
                    completionHandler.handle(Future.failedFuture(maybeBuffer.cause()));
                }
            } else {
                this.processor.process(vertx, this.configuration, (Buffer)maybeBuffer.result(), maybeJson -> {
                    if (maybeJson.failed()) {
                        if (this.optional) {
                            this.logger.warn("Unable to process the retrieve the configuration " + maybeJson.cause().getMessage());
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"Failure caught when processing the configuration", maybeJson.cause());
                            }
                            completionHandler.handle(Future.succeededFuture(new JsonObject()));
                        } else {
                            completionHandler.handle(Future.failedFuture(maybeJson.cause()));
                        }
                    } else {
                        completionHandler.handle(Future.succeededFuture(maybeJson.result()));
                    }
                });
            }
        });
    }

    void close(Handler<Void> handler) {
        this.store.close(handler);
    }

    public ConfigStore getStore() {
        return this.store;
    }

    public ConfigProcessor getProcessor() {
        return this.processor;
    }
}

