/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.impl.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigStore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.utils.FileSet;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.CompositeFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class DirectoryConfigStore
implements ConfigStore {
    private Vertx vertx;
    private File path;
    private final List<FileSet> filesets = new ArrayList<FileSet>();

    public DirectoryConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = vertx;
        String thePath = configuration.getString("path");
        if (thePath == null) {
            throw new IllegalArgumentException("The `path` configuration is required.");
        }
        this.path = new File(thePath);
        if (this.path.isFile()) {
            throw new IllegalArgumentException("The `path` must not be a file");
        }
        JsonArray files = configuration.getJsonArray("filesets");
        if (files == null) {
            throw new IllegalArgumentException("The `filesets` element is required.");
        }
        for (Object o : files) {
            JsonObject json = (JsonObject)o;
            FileSet set = new FileSet(vertx, this.path, json);
            this.filesets.add(set);
        }
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.vertx.executeBlocking(fut -> {
            try {
                fut.complete(FileSet.traverse(this.path).stream().sorted().collect(Collectors.toList()));
            }
            catch (Throwable e) {
                fut.fail(e);
            }
        }, ar -> {
            if (ar.failed()) {
                completionHandler.handle(Future.failedFuture(ar.cause()));
            } else {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (FileSet set : this.filesets) {
                    Promise promise = Promise.promise();
                    set.buildConfiguration((List)ar.result(), json -> {
                        if (json.failed()) {
                            promise.fail(json.cause());
                        } else {
                            promise.complete(json.result());
                        }
                    });
                    futures.add(promise.future());
                }
                CompositeFuture.all(futures).setHandler(cf -> {
                    if (cf.failed()) {
                        completionHandler.handle(Future.failedFuture(cf.cause()));
                    } else {
                        JsonObject json = new JsonObject();
                        futures.stream().map(f -> (JsonObject)f.result()).forEach(config -> json.mergeIn((JsonObject)config, true));
                        completionHandler.handle(Future.succeededFuture(Buffer.buffer(json.encode())));
                    }
                });
            }
        });
    }
}

