/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.impl.spi;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigStore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigStoreFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.utils.JsonObjectHelper;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class EnvVariablesConfigStore
implements ConfigStoreFactory,
ConfigStore {
    private final boolean rawData;
    private final Set<String> keys;
    private JsonObject cached;

    public EnvVariablesConfigStore() {
        this(false, null);
    }

    public EnvVariablesConfigStore(boolean rawData, JsonArray keys) {
        this.rawData = rawData;
        this.keys = keys == null ? null : new HashSet(keys.getList());
    }

    @Override
    public String name() {
        return "env";
    }

    @Override
    public ConfigStore create(Vertx vertx, JsonObject configuration) {
        return new EnvVariablesConfigStore(configuration.getBoolean("raw-data", false), configuration.getJsonArray("keys"));
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        if (this.cached == null) {
            this.cached = EnvVariablesConfigStore.all(System.getenv(), this.rawData, this.keys);
        }
        completionHandler.handle(Future.succeededFuture(Buffer.buffer(this.cached.encode())));
    }

    private static JsonObject all(Map<String, String> env, boolean rawData, Set<String> keys) {
        JsonObject json = new JsonObject();
        Set<String> localKeys = keys == null ? env.keySet() : keys;
        env.forEach((key, value) -> {
            if (localKeys.contains(key)) {
                JsonObjectHelper.put(json, key, value, rawData);
            }
        });
        return json;
    }
}

