/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.impl.spi;

import java.util.concurrent.atomic.AtomicReference;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigStore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.MessageConsumer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class EventBusConfigStore
implements ConfigStore {
    private final MessageConsumer<Object> consumer;
    private AtomicReference<Buffer> last = new AtomicReference();

    public EventBusConfigStore(Vertx vertx, String address) {
        this.consumer = vertx.eventBus().consumer(address);
        this.consumer.handler(message -> {
            Object body = message.body();
            if (body instanceof JsonObject) {
                this.last.set(((JsonObject)body).toBuffer());
            } else if (body instanceof Buffer) {
                this.last.set((Buffer)body);
            }
        });
    }

    @Override
    public void close(Handler<Void> completionHandler) {
        this.consumer.unregister(ar -> completionHandler.handle(null));
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        Buffer buffer = this.last.get();
        if (buffer != null) {
            completionHandler.handle(Future.succeededFuture(buffer));
        } else {
            completionHandler.handle(Future.succeededFuture(Buffer.buffer("{}")));
        }
    }
}

