/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.impl.spi;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigProcessor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class RawProcessor
implements ConfigProcessor {
    @Override
    public String name() {
        return "raw";
    }

    @Override
    public void process(Vertx vertx, JsonObject configuration, Buffer input, Handler<AsyncResult<JsonObject>> handler) {
        String key = configuration.getString("raw.key");
        String type = configuration.getString("raw.type", "string");
        if (key == null) {
            handler.handle(Future.failedFuture("The `raw.key` is required in the configuration when using the `raw` processor."));
        } else {
            JsonObject json = new JsonObject();
            try {
                switch (type) {
                    case "string": {
                        json.put(key, input.toString(configuration.getString("raw.encoding", "utf-8")));
                        handler.handle(Future.succeededFuture(json));
                        break;
                    }
                    case "json-object": {
                        json.put(key, input.toJsonObject());
                        handler.handle(Future.succeededFuture(json));
                        break;
                    }
                    case "json-array": {
                        json.put(key, input.toJsonArray());
                        handler.handle(Future.succeededFuture(json));
                        break;
                    }
                    case "binary": {
                        json.put(key, input.getBytes());
                        handler.handle(Future.succeededFuture(json));
                        break;
                    }
                    default: {
                        handler.handle(Future.failedFuture("Unrecognized `raw.type` : " + type));
                        break;
                    }
                }
            }
            catch (Exception e) {
                handler.handle(Future.failedFuture(e));
            }
        }
    }
}

