/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.ConfigProcessor;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.utils.Processors;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.CompositeFuture;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Promise;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.impl.launcher.commands.FileSelector;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;

public class FileSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSet.class);
    private final String pattern;
    private final ConfigProcessor processor;
    private final File root;
    private final Vertx vertx;
    private final Boolean rawData;

    public FileSet(Vertx vertx, File root, JsonObject set) {
        this.vertx = vertx;
        this.root = root;
        this.pattern = set.getString("pattern");
        if (this.pattern == null) {
            throw new IllegalArgumentException("Each file set needs to contain a `pattern`");
        }
        this.rawData = set.getBoolean("raw-data", false);
        String format = set.getString("format", "json");
        this.processor = Processors.get(format);
        if (this.processor == null) {
            throw new IllegalArgumentException("Unknown configuration format `" + format + "`, supported types are " + Processors.getSupportedFormats());
        }
    }

    private boolean matches(String path) {
        return FileSelector.match(this.pattern, path, false);
    }

    public void buildConfiguration(List<File> files, Handler<AsyncResult<JsonObject>> handler) {
        ArrayList<Future> futures = new ArrayList<Future>();
        files.stream().map(file -> {
            String relative = null;
            if (file.getAbsolutePath().startsWith(this.root.getAbsolutePath())) {
                relative = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
            }
            if (relative == null) {
                LOGGER.warn("The file `" + file.getAbsolutePath() + "` is not in '" + this.root.getAbsolutePath() + "'");
            }
            return relative;
        }).filter(Objects::nonNull).filter(this::matches).map(s2 -> new File(this.root, (String)s2)).forEach(file -> {
            Promise promise = Promise.promise();
            futures.add(promise.future());
            try {
                this.vertx.fileSystem().readFile(file.getAbsolutePath(), buffer -> {
                    if (buffer.failed()) {
                        promise.fail(buffer.cause());
                    } else {
                        this.processor.process(this.vertx, new JsonObject().put("raw-data", this.rawData), (Buffer)buffer.result(), promise);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                promise.fail(e);
            }
        });
        CompositeFuture.all(futures).setHandler(ar -> {
            if (ar.failed()) {
                handler.handle(Future.failedFuture(ar.cause()));
            } else {
                JsonObject result = new JsonObject();
                futures.stream().map(future -> (JsonObject)future.result()).forEach(config -> result.mergeIn((JsonObject)config, true));
                handler.handle(Future.succeededFuture(result));
            }
        });
    }

    public static List<File> traverse(File root) {
        ArrayList<File> files = new ArrayList<File>();
        if (!root.isDirectory()) {
            return files;
        }
        File[] children = root.listFiles();
        if (children == null) {
            return files;
        }
        for (File file : children) {
            if (file.isDirectory()) {
                files.addAll(FileSet.traverse(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }
}

