/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.config.spi.utils;

import java.util.Objects;
import java.util.Properties;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonArray;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class JsonObjectHelper {
    @Deprecated
    public static Buffer toBuffer(JsonObject json) {
        return json.toBuffer();
    }

    public static void put(JsonObject json, String name, String value, boolean rawData) {
        json.put(name, rawData ? value : JsonObjectHelper.convert(value));
    }

    public static Object convert(String value) {
        Objects.requireNonNull(value);
        Boolean bool = JsonObjectHelper.asBoolean(value);
        if (bool != null) {
            return bool;
        }
        Double integer = JsonObjectHelper.asNumber(value);
        if (integer != null) {
            return integer;
        }
        JsonObject obj = JsonObjectHelper.asJsonObject(value);
        if (obj != null) {
            return obj;
        }
        JsonArray arr = JsonObjectHelper.asJsonArray(value);
        if (arr != null) {
            return arr;
        }
        return value;
    }

    private static Double asNumber(String s2) {
        try {
            return Double.parseDouble(s2);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static Boolean asBoolean(String s2) {
        if (s2.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s2.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static JsonObject asJsonObject(String s2) {
        if (s2.startsWith("{") && s2.endsWith("}")) {
            try {
                return new JsonObject(s2);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static JsonArray asJsonArray(String s2) {
        if (s2.startsWith("[") && s2.endsWith("]")) {
            try {
                return new JsonArray(s2);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static JsonObject from(Properties props) {
        return JsonObjectHelper.from(props, false);
    }

    public static JsonObject from(Properties props, boolean rawData) {
        JsonObject json = new JsonObject();
        props.stringPropertyNames().forEach(name -> JsonObjectHelper.put(json, name, props.getProperty((String)name), rawData));
        return json;
    }
}

