/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.impl.clustered;

import java.util.ArrayDeque;
import java.util.Queue;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.EventBusOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.impl.codecs.PingMessageCodec;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetClient;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.ConnectionBase;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.NetClientImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.ServerID;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.EventBusMetrics;

class ConnectionHolder {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHolder.class);
    private static final String PING_ADDRESS = "__vertx_ping";
    private final ClusteredEventBus eventBus;
    private final NetClient client;
    private final ServerID serverID;
    private final Vertx vertx;
    private final EventBusMetrics metrics;
    private Queue<ClusteredMessage> pending;
    private NetSocket socket;
    private boolean connected;
    private long timeoutID = -1L;
    private long pingTimeoutID = -1L;

    ConnectionHolder(ClusteredEventBus eventBus, ServerID serverID, EventBusOptions options) {
        this.eventBus = eventBus;
        this.serverID = serverID;
        this.vertx = eventBus.vertx();
        this.metrics = eventBus.getMetrics();
        NetClientOptions clientOptions = new NetClientOptions(options.toJson());
        ClusteredEventBus.setCertOptions(clientOptions, options.getKeyCertOptions());
        ClusteredEventBus.setTrustOptions(clientOptions, options.getTrustOptions());
        this.client = new NetClientImpl(eventBus.vertx(), clientOptions, false);
    }

    synchronized void connect() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.client.connect(this.serverID.port, this.serverID.host, res -> {
            if (res.succeeded()) {
                this.connected((NetSocket)res.result());
            } else {
                log.warn((Object)("Connecting to server " + this.serverID + " failed"), res.cause());
                this.close(res.cause());
            }
        });
    }

    synchronized void writeMessage(ClusteredMessage message) {
        if (this.connected) {
            Buffer data = message.encodeToWire();
            if (this.metrics != null) {
                this.metrics.messageWritten(message.address(), data.length());
            }
            this.socket.write(data, message.writeHandler());
        } else {
            if (this.pending == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Not connected to server " + this.serverID + " - starting queuing");
                }
                this.pending = new ArrayDeque<ClusteredMessage>();
            }
            this.pending.add(message);
        }
    }

    void close() {
        this.close(ConnectionBase.CLOSED_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause) {
        if (this.timeoutID != -1L) {
            this.vertx.cancelTimer(this.timeoutID);
        }
        if (this.pingTimeoutID != -1L) {
            this.vertx.cancelTimer(this.pingTimeoutID);
        }
        ConnectionHolder connectionHolder = this;
        synchronized (connectionHolder) {
            if (this.pending != null) {
                ClusteredMessage msg;
                Future failure = Future.failedFuture(cause);
                while ((msg = this.pending.poll()) != null) {
                    Handler<AsyncResult<Void>> handler = msg.writeHandler();
                    if (handler == null) continue;
                    handler.handle(failure);
                }
            }
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.eventBus.connections().remove(this.serverID, this) && log.isDebugEnabled()) {
            log.debug("Cluster connection closed for server " + this.serverID);
        }
    }

    private void schedulePing() {
        EventBusOptions options = this.eventBus.options();
        this.pingTimeoutID = this.vertx.setTimer(options.getClusterPingInterval(), id1 -> {
            this.timeoutID = this.vertx.setTimer(options.getClusterPingReplyInterval(), id2 -> {
                log.warn("No pong from server " + this.serverID + " - will consider it dead");
                this.close();
            });
            ClusteredMessage<String, String> pingMessage = new ClusteredMessage<String, String>(this.serverID, PING_ADDRESS, null, null, null, new PingMessageCodec(), true, this.eventBus, null);
            Buffer data = pingMessage.encodeToWire();
            this.socket.write(data);
        });
    }

    private synchronized void connected(NetSocket socket) {
        this.socket = socket;
        this.connected = true;
        socket.exceptionHandler(err -> this.close((Throwable)err));
        socket.closeHandler(v -> this.close());
        socket.handler(data -> {
            this.vertx.cancelTimer(this.timeoutID);
            this.schedulePing();
        });
        this.schedulePing();
        if (this.pending != null) {
            if (log.isDebugEnabled()) {
                log.debug("Draining the queue for server " + this.serverID);
            }
            for (ClusteredMessage message : this.pending) {
                Buffer data2 = message.encodeToWire();
                if (this.metrics != null) {
                    this.metrics.messageWritten(message.address(), data2.length());
                }
                socket.write(data2, message.writeHandler());
            }
        }
        this.pending = null;
    }
}

