/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.impl.codecs;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.MessageCodec;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;

public class JsonObjectMessageCodec
implements MessageCodec<JsonObject, JsonObject> {
    @Override
    public void encodeToWire(Buffer buffer, JsonObject jsonObject) {
        Buffer encoded = jsonObject.toBuffer();
        buffer.appendInt(encoded.length());
        buffer.appendBuffer(encoded);
    }

    @Override
    public JsonObject decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        return new JsonObject(buffer.slice(pos += 4, pos + length));
    }

    @Override
    public JsonObject transform(JsonObject jsonObject) {
        return jsonObject.copy();
    }

    @Override
    public String name() {
        return "jsonobject";
    }

    @Override
    public byte systemCodecID() {
        return 13;
    }
}

