/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.impl.codecs;

import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.CharsetUtil;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.MessageCodec;

public class StringMessageCodec
implements MessageCodec<String, String> {
    @Override
    public void encodeToWire(Buffer buffer, String s2) {
        byte[] strBytes = s2.getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(strBytes.length);
        buffer.appendBytes(strBytes);
    }

    @Override
    public String decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + length);
        return new String(bytes, CharsetUtil.UTF_8);
    }

    @Override
    public String transform(String s2) {
        return s2;
    }

    @Override
    public String name() {
        return "string";
    }

    @Override
    public byte systemCodecID() {
        return 9;
    }
}

