/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.yandex.clickhouse.jdbcbridge.internal.netty.util.internal.PlatformDependent;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxException;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.FileSystemOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.file.impl.FileSystemImpl;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.URIDecoder;

public class FileResolver {
    private static final IntPredicate CACHE_PATH_CHECKER = PlatformDependent.isWindows() ? c -> {
        if (c < 33) {
            return false;
        }
        switch (c) {
            case 34: 
            case 42: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 124: {
                return false;
            }
        }
        return true;
    } : c -> c != 0;
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final boolean NON_UNIX_FILE_SEP = !FILE_SEP.equals("/");
    private static final String JAR_URL_SEP = "!/";
    private static final Pattern JAR_URL_SEP_PATTERN = Pattern.compile("!/");
    private final File cwd;
    private File cacheDir;
    private Thread shutdownHook;
    private final boolean enableCaching;
    private final boolean enableCpResolving;
    private final String fileCacheDir;

    public FileResolver() {
        this(new FileSystemOptions());
    }

    public FileResolver(boolean enableCaching) {
        this(new FileSystemOptions().setFileCachingEnabled(enableCaching));
    }

    public FileResolver(FileSystemOptions fileSystemOptions) {
        this.enableCaching = fileSystemOptions.isFileCachingEnabled();
        this.enableCpResolving = fileSystemOptions.isClassPathResolvingEnabled();
        this.fileCacheDir = fileSystemOptions.getFileCacheDir();
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
        if (this.enableCpResolving) {
            this.setupCacheDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileResolver fileResolver = this;
        synchronized (fileResolver) {
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        this.deleteCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File resolveFile(String fileName) {
        File file = new File(fileName);
        if (this.cwd != null && !file.isAbsolute()) {
            file = new File(this.cwd, fileName);
        }
        if (!this.enableCpResolving) {
            return file;
        }
        FileResolver fileResolver = this;
        synchronized (fileResolver) {
            if (!file.exists()) {
                URL url;
                URL directoryContents;
                String parentFileName;
                File cacheFile = new File(this.cacheDir, fileName);
                if (this.enableCaching && cacheFile.exists()) {
                    return cacheFile;
                }
                ClassLoader cl = this.getClassLoader();
                if (NON_UNIX_FILE_SEP) {
                    fileName = fileName.replace(FILE_SEP, "/");
                }
                if ((parentFileName = file.getParent()) != null && (directoryContents = FileResolver.getValidClassLoaderResource(cl, parentFileName)) != null) {
                    this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                }
                if ((url = FileResolver.getValidClassLoaderResource(cl, fileName)) != null) {
                    return this.unpackUrlResource(url, fileName, cl, false);
                }
            }
        }
        return file;
    }

    private static boolean isValidCachePath(String fileName) {
        int len = fileName.length();
        for (int i = 0; i < len; ++i) {
            char c = fileName.charAt(i);
            if (CACHE_PATH_CHECKER.test(c)) continue;
            return false;
        }
        return true;
    }

    private static URL getValidClassLoaderResource(ClassLoader cl, String fileName) {
        URL resource = cl.getResource(fileName);
        if (resource != null && !FileResolver.isValidCachePath(fileName)) {
            return null;
        }
        return resource;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": 
            case "resource": {
                return this.unpackFromBundleURL(url, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private synchronized File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        File resource = new File(URIDecoder.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource.isDirectory();
        File cacheFile = new File(this.cacheDir, fileName);
        if (!isDirectory) {
            cacheFile.getParentFile().mkdirs();
            try {
                if (this.enableCaching) {
                    Files.copy(resource.toPath(), cacheFile.toPath(), new CopyOption[0]);
                }
                Files.copy(resource.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        } else {
            String[] listing;
            cacheFile.mkdirs();
            for (String file : listing = resource.list()) {
                String subResource = fileName + "/" + file;
                URL url2 = FileResolver.getValidClassLoaderResource(cl, subResource);
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private synchronized File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        ZipFile zip = null;
        try {
            int idx2;
            String path = url.getPath();
            int idx1 = path.lastIndexOf(".jar!");
            if (idx1 == -1) {
                idx1 = path.lastIndexOf(".zip!");
            }
            if ((idx2 = path.lastIndexOf(".jar!", idx1 - 1)) == -1) {
                idx2 = path.lastIndexOf(".zip!", idx1 - 1);
            }
            if (idx2 == -1) {
                File file = new File(URIDecoder.decodeURIComponent(path.substring(5, idx1 + 4), false));
                zip = new ZipFile(file);
            } else {
                String s2 = path.substring(idx2 + 6, idx1 + 4);
                File file = this.resolveFile(s2);
                zip = new ZipFile(file);
            }
            String inJarPath = path.substring(idx1 + 6);
            String[] parts = JAR_URL_SEP_PATTERN.split(inJarPath);
            StringBuilder prefixBuilder = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                prefixBuilder.append(parts[i]).append("/");
            }
            String prefix = prefixBuilder.toString();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefix.isEmpty() ? fileName : prefix + fileName)) continue;
                File file = new File(this.cacheDir, prefix.isEmpty() ? name : name.substring(prefix.length()));
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                try {
                    InputStream is = zip.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        if (this.enableCaching) {
                            Files.copy(is, file.toPath(), new CopyOption[0]);
                            continue;
                        }
                        Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            }
            this.closeQuietly(zip);
        }
        catch (IOException e) {
            try {
                throw new VertxException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zip);
                throw throwable;
            }
        }
        return new File(this.cacheDir, fileName);
    }

    private void closeQuietly(Closeable zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || FileResolver.getValidClassLoaderResource(this.getClassLoader(), url.getPath().substring(1) + "/") != null;
    }

    private synchronized File unpackFromBundleURL(URL url, boolean isDir) {
        block19: {
            try {
                File file = new File(this.cacheDir, url.getHost() + File.separator + url.getFile());
                file.getParentFile().mkdirs();
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    file.mkdirs();
                    break block19;
                }
                file.getParentFile().mkdirs();
                try (InputStream is = url.openStream();){
                    if (this.enableCaching) {
                        Files.copy(is, file.toPath(), new CopyOption[0]);
                    } else {
                        Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        }
        return new File(this.cacheDir, url.getHost() + File.separator + url.getFile());
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCacheDir() {
        String cacheDirName = this.fileCacheDir + "/file-cache-" + UUID.randomUUID().toString();
        this.cacheDir = new File(cacheDirName);
        if (!this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Failed to create cache dir: " + cacheDirName);
        }
        FileResolver fileResolver = this;
        synchronized (fileResolver) {
            this.shutdownHook = new Thread(() -> {
                CountDownLatch latch = new CountDownLatch(1);
                new Thread(() -> {
                    try {
                        this.deleteCacheDir();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    latch.countDown();
                }).run();
                try {
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCacheDir() throws IOException {
        Path path;
        FileResolver fileResolver = this;
        synchronized (fileResolver) {
            if (this.cacheDir == null || !this.cacheDir.exists()) {
                return;
            }
            path = this.cacheDir.toPath();
            this.cacheDir = null;
        }
        FileSystemImpl.delete(path, true);
    }
}

